% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-triangular.R
\name{triangle_plot}
\alias{triangle_plot}
\title{Triangle Distribution PDF Plot}
\usage{
triangle_plot(.data, .interactive = FALSE)
}
\arguments{
\item{.data}{Tidy data from the \code{tidy_triangular} function.}

\item{.interactive}{A logical value indicating whether to return an interactive plot using plotly. Default is FALSE.}
}
\value{
The function returns a ggplot2 object representing the probability density function plot for the triangular distribution.
}
\description{
This function generates a probability density function (PDF) plot for the triangular distribution.
}
\details{
The function checks if the input data is a data frame or tibble, and if it comes from the \code{tidy_triangular}
function. It then extracts necessary attributes for the plot and creates a PDF plot using ggplot2. The plot
includes data points and segments to represent the triangular distribution.
}
\examples{
# Example: Generating a PDF plot for the triangular distribution
data <- tidy_triangular(.n = 50, .min = 0, .max = 1, .mode = 1/2, .num_sims = 1,
.return_tibble = TRUE)
triangle_plot(data)

}
\author{
Steven P. Sanderson II, MPH
}
\concept{Visualization}
