% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-inv-burr-tbl.R
\name{util_inverse_burr_stats_tbl}
\alias{util_inverse_burr_stats_tbl}
\title{Distribution Statistics}
\usage{
util_inverse_burr_stats_tbl(.data)
}
\arguments{
\item{.data}{The data being passed from a \code{tidy_} distribution function.}
}
\value{
A tibble
}
\description{
Returns distribution statistics in a tibble.
}
\details{
This function will take in a tibble and returns the statistics
of the given type of \code{tidy_} distribution. It is required that data be
passed from a \code{tidy_} distribution function.
}
\examples{
library(dplyr)

set.seed(123)
tidy_inverse_burr() |>
  util_inverse_burr_stats_tbl() |>
  glimpse()

}
\seealso{
Other Inverse Burr: 
\code{\link{util_inverse_burr_param_estimate}()}

Other Distribution Statistics: 
\code{\link{util_bernoulli_stats_tbl}()},
\code{\link{util_beta_stats_tbl}()},
\code{\link{util_binomial_stats_tbl}()},
\code{\link{util_burr_stats_tbl}()},
\code{\link{util_cauchy_stats_tbl}()},
\code{\link{util_chisquare_stats_tbl}()},
\code{\link{util_exponential_stats_tbl}()},
\code{\link{util_f_stats_tbl}()},
\code{\link{util_gamma_stats_tbl}()},
\code{\link{util_generalized_beta_stats_tbl}()},
\code{\link{util_generalized_pareto_stats_tbl}()},
\code{\link{util_geometric_stats_tbl}()},
\code{\link{util_hypergeometric_stats_tbl}()},
\code{\link{util_inverse_pareto_stats_tbl}()},
\code{\link{util_inverse_weibull_stats_tbl}()},
\code{\link{util_logistic_stats_tbl}()},
\code{\link{util_lognormal_stats_tbl}()},
\code{\link{util_negative_binomial_stats_tbl}()},
\code{\link{util_normal_stats_tbl}()},
\code{\link{util_paralogistic_stats_tbl}()},
\code{\link{util_pareto1_stats_tbl}()},
\code{\link{util_pareto_stats_tbl}()},
\code{\link{util_poisson_stats_tbl}()},
\code{\link{util_t_stats_tbl}()},
\code{\link{util_triangular_stats_tbl}()},
\code{\link{util_uniform_stats_tbl}()},
\code{\link{util_weibull_stats_tbl}()},
\code{\link{util_zero_truncated_binomial_stats_tbl}()},
\code{\link{util_zero_truncated_geometric_stats_tbl}()},
\code{\link{util_zero_truncated_negative_binomial_stats_tbl}()},
\code{\link{util_zero_truncated_poisson_stats_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Distribution Statistics}
\concept{Inverse Burr}
