% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToothDF.R
\name{ToothDF}
\alias{ToothDF}
\title{ToothDF}
\usage{
ToothDF(
  tooth.thickness,
  rem.out = TRUE,
  fac.out = 0.5,
  smooth = TRUE,
  scale = TRUE,
  smooth.iter = 5,
  method = "equiangular",
  labels = c("Li", "Mes", "Bu", "D", "Li"),
  relThick = FALSE
)
}
\arguments{
\item{tooth.thickness}{list: tooth.Thickness object}

\item{rem.out}{logical: if TRUE the outlier will be removed}

\item{fac.out}{numeric: parameter to set the threshold in outliers detection}

\item{smooth}{logical: if TRUE the smooth algorithm is applied}

\item{scale}{logical: if TRUE the thichkness matrix is scaled from 0 to 1}

\item{smooth.iter}{numeric: number of smoothing iterations}

\item{method}{character: if set on "equiangular" the dental thickness is meant as the distance of the segment intersecting the external and internal outline starting from the centroid of the section. If set on "closest" the dental thickness is calculated at each point as the closest distance between external and internal outlines}

\item{labels}{character vector: names for x labels in the morphometric map}

\item{relThick}{logical: if TRUE the dental thickness is converted into relative dental thickness}
}
\value{
XYZ data.frame for morphometric map

labels character vector for x labels in the morphometric map
}
\description{
Tool to build a data.frame suitable for morphometric maps
}
\author{
Antonio Profico; Mathilde Augoyard
}
