% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{na_trim}
\alias{na_trim}
\title{Supprime les NA aux bords}
\usage{
na_trim(series, sides = c("both", "left", "right"))
}
\arguments{
\item{series}{un objet ts unidimensionnel conforme aux règles de assert_ts}

\item{sides}{une chaine de caractere qui spécifie quelle NA doivent être
retirés (au début et à la fin ("both"), juste au début ("left") ou juste à
la fin ("right"))}
}
\value{
En sortie, la fonction retourne une copie de l'objet \code{series} corrigé
des NA et début et fin de série.
}
\description{
La fonction \code{na_trim} supprime les NA en début et en fin de
période.
}
\details{
L'objet retourné commence et finis par des valeurs non manquantes.
}
\examples{

ts1 <- ts(c(rep(NA, 3L), 1:10, rep(NA, 3L)), start = 2020, frequency = 12)
ts2 <- ts(c(1:10, rep(NA, 3L)), start = c(2023, 2), frequency = 4)
ts3 <- ts(c(rep(NA, 3L), 1:10), start = 2000, frequency = 12)

na_trim(ts1)
na_trim(ts2)
na_trim(ts3)

}
