% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcEuroLotteryPnL.R
\name{CalcEuroLotteryPnL}
\alias{CalcEuroLotteryPnL}
\title{PnL calculation for EuroMillions/EuroJackpot backtesting}
\usage{
CalcEuroLotteryPnL(backtested_results, plot_results = FALSE)
}
\arguments{
\item{backtested_results}{The EuroMillions/EuroJackpot results backtested against the user input}

\item{plot_results}{(Optional) If TRUE, the P&L historical graphs are plotted, default FALSE}
}
\value{
PnL figures
}
\description{
Calculates the PnL for a pay out structure created during backtesting
}
\examples{

euromillions_results = EuroMillionsResults()
user_input = c(10,20,30,40,50,5,10)
backtested_results = EuroLotteryBacktesting(euromillions_results, '2005-01-01', user_input)
pnl_result = CalcEuroLotteryPnL(backtested_results, plot_results = TRUE)
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
