% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Collateral.R
\docType{class}
\name{Collateral-class}
\alias{Collateral-class}
\alias{Collateral}
\title{Collateral Class}
\arguments{
\item{ID}{The ID of each object}

\item{Amount}{The collateral amount}

\item{csa_id}{The csa_id that this object is linked with}

\item{type}{Describes the type of the collateral: can be "ICA", "VariationMargin" etc}
}
\value{
An object of type Collateral
}
\description{
Creates a Collateral amount object which needs to be linked with a CSA ID
}

\examples{


colls = list()
coll_raw = read.csv(system.file("extdata", "coll.csv", package = "Trading"),header=TRUE,
stringsAsFactors = FALSE)

for(i in 1:nrow(coll_raw))
{
 colls[[i]] = Collateral()
 colls[[i]]$PopulateViaCSV(coll_raw[i,])
}
}
\references{
Basel Committee: The standardised approach for measuring counterparty credit risk exposures
http://www.bis.org/publ/bcbs279.htm
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
