% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{probTTree}
\alias{probTTree}
\title{Calculates the log-probability of a transmission tree}
\usage{
probTTree(
  ttree,
  rOff,
  pOff,
  pi,
  shGen,
  scGen,
  shSam,
  scSam,
  dateT,
  delta_t = 0.01
)
}
\arguments{
\item{ttree}{Transmission tree}

\item{rOff}{First parameter of the negative binomial distribution for offspring number}

\item{pOff}{Second parameter of the negative binomial distribution for offspring number}

\item{pi}{probability of sampling an infected individual}

\item{shGen}{Shape parameter of the Gamma probability density function representing the generation time}

\item{scGen}{Scale parameter of the Gamma probability density function representing the generation time}

\item{shSam}{Shape parameter of the Gamma probability density function representing the sampling time}

\item{scSam}{Scale parameter of the Gamma probability density function representing the sampling time}

\item{dateT}{Date when process stops (this can be Inf for fully simulated outbreaks)}

\item{delta_t}{Grid precision}
}
\value{
Probability of the transmission tree
}
\description{
Calculates the log-probability of a transmission tree
}
