% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetGtexExp.R
\name{get_gtex_exp}
\alias{get_gtex_exp}
\title{Get GTEx Expression Data for Specific Organ}
\usage{
get_gtex_exp(
  organ_specific,
  file_path,
  probe_map_path,
  pheno_path,
  output_path
)
}
\arguments{
\item{organ_specific}{A character string specifying the organ to filter the gene expression data by.}

\item{file_path}{A character string specifying the path to the GTEx gene expression data file.}

\item{probe_map_path}{A character string specifying the path to the gtex_probeMap_gencode data file.}

\item{pheno_path}{A character string specifying the path to the GTEx phenotype data file.}

\item{output_path}{A character string specifying the path where the output RDS file will be saved.}
}
\value{
A data frame containing gene expression data for the specified organ.
        Rows represent genes, and columns represent samples. Note that this function also saves the
        organ-specific GTEx data as an RDS file at the specified output path.
}
\description{
This function retrieves gene expression data from the GTEx project that is specific to a certain organ.
It performs various checks and processing steps to ensure that the data is consistent and relevant to the
specified organ. The filtered and cleaned data is saved as an RDS file for further analysis.
}
\details{
The function begins by checking if the gene expression and phenotype data files exist at
         the specified paths. It then loads these data files and processes them by setting appropriate row names,
         modifying column names for clarity, and filtering samples based on the specified organ. The function ensures
         that only samples present in both datasets are retained for consistency. It also removes any duplicate gene
         entries to prevent redundancy. Finally, the processed data is saved as an RDS file.
}
\note{
The function will stop and throw an error if the input files do not exist, or if no samples are found
      for the specified organ.

CRITICAL: The 'output_path' parameter must end with '.rds' to be properly recognized by the function. It is also highly recommended
      that the path includes specific identifiers related to the target samples. Please structure the 'output_path' following this pattern: './your_directory/your_sample_type.gtex.rds'.
}
