% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEventDuration.R
\name{plotEventDuration}
\alias{plotEventDuration}
\title{plotEventDuration}
\usage{
plotEventDuration(
  eventDurations,
  minCellCount = 0,
  treatmentGroups = "both",
  eventLines = NULL,
  includeOverall = TRUE
)
}
\arguments{
\item{eventDurations}{(\code{data.frame})
Contents of \code{summaryEventDuration.csv} file.}

\item{minCellCount}{(\code{numeric(1)}:  \code{0})
Min Cell Count per event group.}

\item{treatmentGroups}{(\code{character(1)}: \code{"both"})
\code{"group"}: Only mono-, and combination-events.
\code{"individual"}: Only individual (combination) events.
\code{"both"}: Both mono-, and combination-events, and individual (combination) events.}

\item{eventLines}{(\code{numeric(n)}: \code{NULL})
Event lines to include, i.e. \code{c(1, 2, 3)} includes first (\code{1}), second (\code{2}), and third (\code{3}) lines of events.
\code{NULL} will include all \code{eventLines}.}

\item{includeOverall}{(\code{logical(1)}: \code{TRUE})
\code{TRUE}: Include an overall column with the \code{eventLines}.
\code{FALSE}: Exclude the overall column.}
}
\value{
\code{ggplot}
}
\description{
plotEventDuration
}
\examples{
\donttest{
ableToRun <- all(
  require("CirceR", character.only = TRUE, quietly = TRUE),
  require("CDMConnector", character.only = TRUE, quietly = TRUE),
  require("TreatmentPatterns", character.only = TRUE, quietly = TRUE),
  require("dplyr", character.only = TRUE, quietly = TRUE)
)

if (ableToRun) {
  withr::local_envvar(
    R_USER_CACHE_DIR = tempfile(),
    EUNOMIA_DATA_FOLDER = Sys.getenv("EUNOMIA_DATA_FOLDER", unset = tempfile())
  )

  tryCatch({
    if (Sys.getenv("skip_eunomia_download_test") != "TRUE") {
      CDMConnector::downloadEunomiaData(overwrite = TRUE)
    }
  }, error = function(e) NA)

  con <- DBI::dbConnect(duckdb::duckdb(), dbdir = eunomiaDir())
  cdm <- cdmFromCon(con, cdmSchema = "main", writeSchema = "main")

  cohortSet <- readCohortSet(
    path = system.file(package = "TreatmentPatterns", "exampleCohorts")
  )

  cdm <- generateCohortSet(
    cdm = cdm,
    cohortSet = cohortSet,
    name = "cohort_table"
  )

  cohorts <- cohortSet \%>\%
    # Remove 'cohort' and 'json' columns
    select(-"cohort", -"json") \%>\%
    mutate(type = c("event", "event", "event", "event", "exit", "event", "event", "target")) \%>\%
    rename(
      cohortId = "cohort_definition_id",
      cohortName = "cohort_name",
    ) \%>\%
    select("cohortId", "cohortName", "type")

  outputEnv <- computePathways(
    cohorts = cohorts,
    cohortTableName = "cohort_table",
    cdm = cdm
  )

  results <- export(outputEnv)

  plotEventDuration(
    eventDurations = results$summary_event_duration,
    minCellCount = 5,
    treatmentGroups = "group",
    eventLines = 1:4,
    includeOverall = FALSE
  )

  Andromeda::close(outputEnv)
  DBI::dbDisconnect(con, shutdown = TRUE)
}
}
}
