% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VBGF.R
\name{VBGF}
\alias{VBGF}
\title{Von Bertalanffy Growth function (VBGF)}
\usage{
VBGF(param, t = NA, L = NA, na.rm = FALSE)
}
\arguments{
\item{param}{a list with following potential objects:
\itemize{
  \item \code{Linf}: infinite length for investigated species in cm, or
  \item \code{Winf}: infinite weight for investigated species in gramm
  \item \code{K}: growth coefficent for investigated species per year
  \item \code{t0}: theoretical time zero, at which individuals of this species hatch (default: 0)
  \item \code{b}: exponent of weight length relationship (default: 3)
  \item \code{D}: surface factor (default: 1)
  \item \code{L0}: length at hatching for VBGF with L0
  \item \code{ts}: onset of the first oscillation relative to t0
  \item \code{C}: intensity of (sinusoid) growth oscillations. Default is no oscillation (C = 0)
}}

\item{t}{ages for which to calculate corresponding lengths, or}

\item{L}{lengths for which to calculate corresponding ages}

\item{na.rm}{logical; should NA in input length or age vector be omitted? (default: FALSE)}
}
\value{
A vector with estimated lengths corresponding to provided ages.
}
\description{
This function applies the von Bertalanffy growth function (VBGF).
   It allows to calculate ages from lengths or lengths from ages based on the special,
   generalised or seasonalised VBGF.
}
\details{
Based upon which input parameters are given one of the following
VBGF types is applied: "special", "generalised", or "seasonalised" VBGF.
}
\examples{
# calculation of lengths
# with t0
t <- seq(0,6,0.1)
Lt <- VBGF(list(Linf=80, K=0.6, t0=-0.1),t=t)
plot(t, Lt, t="l")

# with L0
t <- seq(0,6,0.1)
Lt <- VBGF(list(Linf=80, K=0.6, L0=2),t=t)
plot(t, Lt, t="l")

# with Winf
t <- seq(0,6,0.1)
Wt <- VBGF(list(Winf=4000, K=0.8), t=t)
plot(t, Wt, t="l")

# seasonalised VBGF
t <- seq(0,6,0.1)
Lt <- VBGF(list(Linf=80, K=0.6, t0=-0.1, ts=0.5, C=0.75),t=t)
plot(t, Lt, t="l")


# calculation of ages
L <- seq(2,200,0.1)
t <- VBGF(L = L, list(Linf=210, K=0.8, C= 0.75))
plot(t, L, t="l")

}
\references{
Somers, I. F. (1988). On a seasonally oscillating growth function.
Fishbyte, 6(1), 8-11

Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2). 407 p.
}
\keyword{VBGF}
\keyword{function}
\keyword{growth}
