% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_budget.R
\name{create_budget}
\alias{create_budget}
\title{Create budget}
\usage{
create_budget(
  budget,
  Rastercurrentlanduse,
  landuses,
  name = "Problem",
  verbose = FALSE
)
}
\arguments{
\item{budget}{maximum cost for the problem}

\item{Rastercurrentlanduse}{raster object of current landuses}

\item{landuses}{character vector with all landuses}

\item{name}{The name of the output file}

\item{verbose}{Logical whether messages will be written while the
function is generating calculations, defaults to FALSE}
}
\value{
A .dat file. This function is used for the side-effect of writing values to a file.
}
\description{
This function generates or appends the budget and transition cost to
a .dat file for ampl. The file
will be written to the location specified by the \code{name} argument. If the file
already exists, it will be overwritten. The file format is plain text, with each
line terminated by a newline character.
}
\examples{

data(CurrentLanduse)
CurrentLU <- terra::unwrap(CurrentLanduse)


TroublemakeR::create_budget(budget = 2,
Rastercurrentlanduse = CurrentLU,
landuses = c("Agriculture", "Forest", "Urban"),
name = "Problem",
verbose = TRUE)

# delete the file so the test on cran can pass this

file.remove("Problem.dat")

}
\author{
Derek Corcoran
}
