% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trandn.R
\name{trandn}
\alias{trandn}
\title{Fast truncated normal generator}
\usage{
trandn(l, u)
}
\arguments{
\item{l}{lower truncation limit}

\item{u}{upper truncation limit}
}
\value{
random variable drawn from the truncated normal distribution
}
\description{
Efficient state-of-the-art generator of a vector of \code{length(l)=length(u)}
 from the standard multivariate normal distribution truncated over the region \eqn{[l,u]}.
 Infinite values for \code{u} and \code{l} are accepted.
}
\details{
Suppose we wish to simulate a random variable \eqn{Z} drawn from \eqn{N(\mu,\sigma^2)} and
 conditional on \eqn{l<Z<u} using the inverse transform method.
 To achieve this, first compute
 \code{X=norminvp(runif(1),(l-mu)/sig,(u-mu)/sig)} and then set
 \code{Z=mu+sig*X}
}
\note{
Use \code{\link{norminvp}} for the (slower) inverse transform method of simulating truncated normal variables.
}
\examples{
trandn(l = 1,u = Inf)
trandn(l = rep(1, 10), u = rep(Inf, 10))
}
\references{
Z. I. Botev (2017), \emph{The Normal Law Under Linear Restrictions:
Simulation and Estimation via Minimax Tilting}, Journal of the Royal
Statistical Society, Series B, \bold{79} (1), pp. 1--24.
}
\seealso{
\code{\link{norminvp}}
}
\author{
Zdravko I. Botev
}
\keyword{internal}
