\name{Lp}
\alias{Lp}
\alias{Lt}
\alias{Ll}

\title{
Likelihood functions
}

\description{
Lp is the likelihood function for the power model psy(s,a)=s^exp(a).
Lt is the likelihood function for the hyperbolic tangent model psy(s,a)= ((tanh(s)+1)/2)**a.
Ll is the likelihood function for the logistic model psy(s,a) = exp(3+a*s)/(1+exp(3+a*s)).
}

\usage{
Lp(a, data, sgl)
Lt(a, data, sgl)
Ll(a, data, sgl)
}

\arguments{
  \item{a}{Parameter.
}

  \item{data}{CRM dataframe with a CreData() structure.
}

  \item{sgl}{Dose level singleton.
}
}

\value{
Numeric value of the computed likelihood.
}

\references{
O'Quigley J., Pepe M., Fisher L. (1990). Continual Reassessment Method: a practical design for Phase I clinical trials in cancer. Biometrics 46, 33-48. <https://doi.org/10.2307/2531628>

O'Quigley J., Shen LZ. (1996). Continual Reassessment Method: a likelihood approach. Biometrics 52, 673-684. <https://doi.org/10.2307/2532905>

Paoletti X., Kramar A. (2009). A comparison of model choices for the Continual Reassessment Method in phase I cancer trials. Statistics in Medecine 28, 3012-3028. <https://doi.org/10.1002/sim.3682>

Chamorey Emmanuel. (2009). Methodologie des essais de phase precoce en cancerologie: evolution des schemas et apport de la pharmacologie. These.

Garret-Mayer Elizabeth. (2006). The Continual Reassessment Method for dose-finding studies: a tutorial. Clinical Trials: 57-71. <https://doi.org/10.1191/1740774506cn134oa>
}

\author{
Benjamin Esterni, Baboukar Mane. Unite de Biostatistique et de Methodologie, Institut Paoli-Calmettes, Marseille, France.

}
