% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UGa.R
\name{UGa}
\alias{UGa}
\alias{dUGa}
\alias{pUGa}
\alias{qUGa}
\alias{rUGa}
\title{The Unit-Garima distribution (UGa)}
\usage{
dUGa(x, theta, log = FALSE)

pUGa(q, theta, lower.tail = TRUE, log.p = FALSE)

qUGa(p, theta = 0.5)

rUGa(n, theta)
}
\arguments{
\item{x, q}{vector of quantile.}

\item{theta}{shape parameter, where \eqn{\theta > 0}.}

\item{log, log.p}{logical; (default = \code{FALSE}), if \code{TRUE}, then probabilities are given as \code{log(p)}.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dUGa} gives the density,
\code{pUGa} gives the distribution function,
\code{qUGa} gives the quantile function,
and \code{rUGa} generates random samples.
}
\description{
Density, distribution function, quantile function, and random generation function
for UGa distribution with one parameter (\code{theta}). See details in references.
}
\examples{
NULL

x <- seq(0.1,1,by=0.1)
dUGa(x,theta=0.5)           #f(x)
dUGa(x,theta=0.5,log=TRUE)  #log(f(x))

pUGa(x,theta=1.5)                        #P(X<x)
pUGa(x,theta=1.5,lower.tail = FALSE )    #P(X>x)

# library(lamW) is required for qUGa() function
x <- seq(0.1,1,by=0.1)
x
p <- pUGa(x,theta=2.5)
p
require(lamW)
q <- qUGa(p,theta=2.5)
q     # q equal to x

# library(lamW) is required for rUGa() function
require(lamW)
x <- rUGa(100,theta=1)
x     #  0<x<1, for all x
}
\references{
Ayuyuen, S., & Bodhisuwan, W. (2024). A generating family of unit-Garima distribution: Properties, likelihood inference, and application.
Pakistan Journal of Statistics and Operation Research, 20(1), 69-84. doi:10.18187/pjsor.v20i1.4307.
}
