% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZIHR.R
\name{ZIHR}
\alias{ZIHR}
\title{Zero-inflation hurdle regression models}
\usage{
ZIHR(
  modelY,
  modelZ,
  data,
  n.chains = n.chains,
  n.iter = n.iter,
  n.burnin = n.burnin,
  n.thin = n.thin,
  family = "Gaussian"
)
}
\arguments{
\item{modelY}{a formula for the mean of the count response. This argument is identical to the one in the "glm" function.}

\item{modelZ}{a formula for the probability of zero. This argument is identical to the one in the "glm" function.}

\item{data}{data set of observed variables.}

\item{n.chains}{the number of parallel chains for the model; default is 1.}

\item{n.iter}{integer specifying the total number of iterations; default is 1000.}

\item{n.burnin}{integer specifying how many of n.iter to discard as burn-in ; default is 5000.}

\item{n.thin}{integer specifying the thinning of the chains; default is 1.}

\item{family}{Family objects streamline the specification of model details for functions like glm. They cover various distributions like "Gaussian", "Exponential", "Weibull", "Gamma", "Beta", "inverse.gaussian", "Poisson", "NB", "Logarithmic", "Bell", "GP", and "Binomial". Specifically, "NB" and "GP" are tailored for hurdle negative binomial and hurdle generalized Poisson models, respectively, while the others are utilized for the corresponding models based on their names.}
}
\value{
\itemize{
\item MCMC chains for the unknown parameters
\item Est list of posterior mean for each parameter
\item SD list of standard error for each parameter
\item L_CI list of 2.5th percentiles of the posterior distribution serves as the lower bound of the Bayesian credible interval
\item U_CI list of 97.5th percentiles of the posterior distribution serves as the lower bound of the Bayesian credible interval
\item Rhat Gelman and Rubin diagnostic for all parameter
\item beta the regression coefficients of mean of the hurdle model
\item alpha the regression coefficients of probability of the hurdle model
\item The variance, over-dispersion, dispersion, or scale parameters of models depend on the family used
\item DIC deviance information criterion
\item LPML Log Pseudo Marginal Likelihood (LPML) criterion
}
}
\description{
Fits zero-inflated hurdle regression models
}
\details{
A function utilizing the 'JAGS' software to estimate the linear hurdle regression model.
}
\examples{
# Example 1
data(dataD)
index <- 1:(dim(dataD)[1])
IND_new <- sample(index, .5 * length(index))
datat <- dataD[IND_new, ]
datav <- dataD[-IND_new, ]
modelY <- y~x1 + x2
modelZ <- z~x1
D1 <- ZIHR(modelY, modelZ,
           data = datat, n.chains = 2, n.iter = 1000,
           n.burnin = 500, n.thin = 1, family = "Poisson"
)

\donttest{
  SummaryZIHR(D1)
  Prediction(D1, data = datav)


  D2 <- ZIHR(modelY, modelZ,
             data = datat, n.chains = 2, n.iter = 1000,
             n.burnin = 500, n.thin = 1, family = "Bell"
  )
  SummaryZIHR(D2)



  # Example 2
  data(dataC)
  modelY <- y~x1 + x2
  modelZ <- z~x1
  C <- ZIHR(modelY, modelZ,
            data = dataC, n.chains = 2, n.iter = 1000,
            n.burnin = 500, n.thin = 1, family = "Gaussian"
  )
  SummaryZIHR(C)

  Prediction(C, data = datav)



  # Example 3
  data(dataP)
  modelY <- y~x1 + x2
  modelZ <- z~x1
  P1 <- ZIHR(modelY, modelZ,
             data = dataP, n.chains = 2, n.iter = 1000,
             n.burnin = 500, n.thin = 1, family = "Exponential"
  )
  SummaryZIHR(P1)

  P2 <- ZIHR(modelY, modelZ,
             data = dataP, n.chains = 2, n.iter = 1000,
             n.burnin = 500, n.thin = 1, family = "Gamma"
  )
  SummaryZIHR(P2)

  P3 <- ZIHR(modelY, modelZ,
             data = dataP, n.chains = 2, n.iter = 1000,
             n.burnin = 500, n.thin = 1, family = "Weibull"
  )
  SummaryZIHR(P3)


  # Example B
  data(dataB)
  modelY <- y~x1 + x2
  modelZ <- z~x1
  P <- ZIHR(modelY, modelZ,
            data = dataB, n.chains = 2, n.iter = 1000,
            n.burnin = 500, n.thin = 1, family = "Beta"
  )
  SummaryZIHR(P)

  # Example C
  data(dataI)
  modelY <- y~x1 + x2
  modelZ <- z~x1
  P4 <- ZIHR(modelY, modelZ,
             data = dataI, n.chains = 2, n.iter = 1000,
             n.burnin = 500, n.thin = 1, family = "inverse.gaussian"
  )
  SummaryZIHR(P4)
}
}
\author{
Taban Baghfalaki \email{t.baghfalaki@gmail.com}, Mojtaba Ganjali \email{m-ganjali@sbu.ac.ir}
}
