% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{WeightedMoments}
\alias{WeightedMoments}
\title{Weighted Lmoment ratios (LCV and LSKEW) from a pooling group}
\usage{
WeightedMoments(x)
}
\arguments{
\item{x}{pooling group derived with the Pool() function}
}
\value{
A data.frame with site references in the first column and associated weights in the second
}
\description{
Provides the weighted LCV and LSKEW for a pooling group
}
\details{
Weighting method as according to: FEH2025
}
\examples{
# Get some CDs, form a gauged pooling group, and estimate gauged Lcv
cds_27051 <- GetCDs(27051)
pool_27051 <- Pool(cds_27051)
WeightedMoments(pool_27051)

}
\author{
Anthony Hammond
}
