% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rastPCA.R
\name{rastPCA}
\alias{rastPCA}
\title{Principal Component Analysis for Rasters}
\usage{
rastPCA(env.rast, nPC = NULL, naMask = TRUE, stand = FALSE)
}
\arguments{
\item{env.rast}{A RasterStack, RasterBrick or a SpatRaster object comprising the variables describing the environmental space.}

\item{nPC}{Integer. Number of PCA components to return.}

\item{naMask}{Logical. Masks all pixels which have at least one NA (default \code{TRUE} is recommended but introduces a slow-down.}

\item{stand}{Logical. If \code{TRUE}, perform standardized PCA. Corresponds to centered and scaled input image. This is usually beneficial for equal weighting of all layers. (\code{FALSE} by default)}
}
\value{
Returns a named list containing the PCA model object ($pca) and the SpatRaster with the principal component layers ($PCs).
}
\description{
The \code{rastPCA} function calculates the principal component analysis  (PCA) for SpatRaster, RasterBrick, or RasterStack objects and returns a SpatRaster with multiple layers representing the PCA components. Internally, \code{rastPCA} utilizes the \link[stats]{princomp} function for R-mode PCA analysis. The covariance matrix is computed using all the observations within the provided SpatRaster object, which describes the environmental conditions.
The covariance matrix obtained is subsequently utilized as input for the \code{princomp} function, which conducts the PCA. The resulting PCA components are then used to generate the final SpatRaster, consisting of multiple layers that represent the PCA components.
}
\details{
Pixels with missing values in one or more bands will be set to NA. The built-in check for such pixels can lead to a slow-down of rastPCA.
However, if you make sure or know beforehand that all pixels have either only valid values or only NAs throughout all layers you can disable this check
by setting \code{naMask=FALSE} which speeds up the computation.

Standardized PCA (\code{stand=TRUE}) can be useful if imagery or bands of different dynamic ranges are combined. In this case, the correlation matrix is computed instead of the covariance matrix, which
has the same effect as using normalised bands of unit variance.
}
\seealso{
The \code{rastPCA} function has been conceptualized starting from \code{RStoolbox::rasterPCA} (\url{https://github.com/bleutner/RStoolbox}).
}
