% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tract.R
\docType{data}
\name{tract2000}
\alias{tract2000}
\title{Centers of population of US census tracts according to the 2000 census}
\format{
A \code{\link[tibble]{tibble}} with 66,304 rows and 6 variables:

  \describe{

  \item{STATEFP}{The two-digit GEOID of the state where the tract is located}

  \item{COUNTYFP}{The last three digits of the five-digit GEOID of the tract}

  \item{TRACTCE}{The last six digits of the eleven-digit GEOID of the tract}

  \item{POPULATION}{The population of the tract}

  \item{LATITUDE}{The latitude coordinate of the center of population
  (centroid) of the tract (positive is north; negative is south)}

  \item{LONGITUDE}{The longitude coordinate of the center of population
  (centroid) of the tract (positive is east; negative is west)}

  }
}
\source{
The source file is at
  \url{https://www2.census.gov/geo/docs/reference/cenpop2000/tract/tract_pop.txt}.
  The 2000 center of population info page is at
  \url{https://www.census.gov/geographies/reference-files/time-series/geo/centers-population.2000.html}
}
\usage{
tract2000
}
\description{
A data set of the latitude and longitude coordinates of the centers of
population (centroids) of census tracts in the US states plus the District of
Columbia and Puerto Rico. Populations according to the 2000 decennial census
are also included.
}
\details{
\strong{There are 307 tracts with a \code{POPULATION} of 0 and a missing
value for both \code{LATITUDE} and \code{LONGITUDE}}.

Unlike \code{\link{county2000}}, \code{tract2000} does not contain data from
American Samoa, Guam, the Northern Mariana Islands, or the US Virgin Islands.
}
\section{US census data terms of service}{

  \url{https://www.census.gov/data/developers/about/terms-of-service.html}
}

\examples{
tract2000
}
\seealso{
Other 2000 census centers of population: \code{\link{state2000}};
  \code{\link{county2000}}; \code{\link{block_group2000}}

  2010 census centers of population: \code{\link{state2010}};
  \code{\link{county2010}}; \code{\link{tract2010}};
  \code{\link{block_group2010}}; \code{\link{US_mean_center2010}};
  \code{\link{US_median_center2010}}

  2020 census centers of population: \code{\link{state2020}};
  \code{\link{county2020}}; \code{\link{tract2020}};
  \code{\link{block_group2020}}; \code{\link{US_mean_center2020}};
  \code{\link{US_median_center2020}}
}
\keyword{datasets}
