% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VBJM_wrapper.R
\name{VBJM_fit}
\alias{VBJM_fit}
\title{The function to fit VBJM.}
\usage{
VBJM_fit(
  LongData = NULL,
  SurvData = NULL,
  marker.name = NULL,
  control_list = NULL,
  maxiter = 100,
  eps = 1e-04
)
}
\arguments{
\item{LongData}{a data frame containing the longitudinal data
(see \code{\link{LongData}}).}

\item{SurvData}{a data frame containing the survival data
(see \code{\link{SurvData}}).}

\item{marker.name}{a vector indicating which set of longitudinal biomarkers
to be analyzed. If NULL, all biomarkers in LongData will be used.}

\item{control_list}{a list of parameters specifying the joint model
(see \code{\link{control_list}}).}

\item{maxiter}{the maximum number of iterations.}

\item{eps}{threshold for convergence.}
}
\value{
return a data frame with estimates, standard errors, and
95\% CIs for each of the following parameters, where VAR indicates
the corresponding variable name.
\item{VAR_alpha}{the parameters for the effects of biomarkers
in the survival submodel, where VAR indicates the names
for the biomarkers.}
\item{Weibull_shape}{the shape parameter in the
 Weibull baseline hazard in the survival submodel.}
\item{Weibull_scale}{the scale parameter in the
 Weibull baseline hazard in the survival submodel.}
 \item{Surv_gamma_VAR}{the parameters for the effects of baseline covariates
in the survival submodel.}
\item{VAR_fix}{the parameters for the fixed-effects
in the longitudinal submodel.}
}
\description{
The function is used to fit joint models using variational inference algorithm.
}
\examples{
data(VBJMdata)
flex_time_fun <- function(x=NULL){
    xx = matrix(x, ncol = 1)
    colnames(xx) = c("year_l")
    xx
}
ran_time_ind = 1 ## random time-trend effects
control_list = list(
  ID_name = "ID", item_name = "item",
  value_name = "value",  time_name = "years",
  fix_cov = NULL, random_cov = NULL,
  FUN = flex_time_fun, ran_time_ind=ran_time_ind,
  surv_time_name = "ftime",  surv_status_name = "fstat",
  surv_cov = "x", n_points = 5
)
\donttest{
## takes about one minute.
res = VBJM_fit(LongData=LongData, SurvData=SurvData,
               control_list=control_list)
}

}
\references{
Jieqi Tu and Jiehuan Sun (2023). "Gaussian variational
approximate inference for joint models of longitudinal biomarkers
 and a survival outcome". Statistics in Medicine, 42(3), 316-330.
}
