% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsCvrt.R
\name{ts2dl}
\alias{ts2dl}
\title{Convert a structured character tensor to double list}
\usage{
ts2dl(x, ...)
}
\arguments{
\item{x}{A structured character tensor to be converted.}

\item{...}{Argument in \code{\link[VBTree:chrvec2dl]{chrvec2dl}} to control split pattern.}
}
\value{
Return a double list based on the input tensor.
}
\description{
Convert a structured character tensor to a double list. All character elements in tensor will be splited by
a specific pattern then sorted intrinsically in each layer of the double list.
}
\examples{
#Write the column names of datatest into a tensor:
ts <- dl2ts(chrvec2dl(colnames(datatest)))

#Recover the double list from character tensor:
ts2dl(ts)
}
\seealso{
\code{\link[VBTree:ts2vbt]{ts2vbt}}, \code{\link[VBTree:chrvec2dl]{chrvec2dl}}.
}
\keyword{Double.List}
\keyword{tensor}
