% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PX-CAVI-Laplace.R
\name{spca.cavi.Laplace}
\alias{spca.cavi.Laplace}
\title{Function for the PX-CAVI algorithm using the Laplace slab}
\usage{
spca.cavi.Laplace(
  x,
  r = 1,
  lambda = 1,
  max.iter = 100,
  eps = 0.001,
  sig2.true = NA,
  threshold = 0.5,
  theta.int = NA,
  theta.var.int = NA,
  kappa.para1 = NA,
  kappa.para2 = NA,
  sigma.a = NA,
  sigma.b = NA
)
}
\arguments{
\item{x}{Data an \eqn{n*p} matrix.}

\item{r}{Rank.}

\item{lambda}{Tuning parameter for the density \eqn{g}.}

\item{max.iter}{The maximum number of iterations for running the algorithm.}

\item{eps}{The convergence threshold; the default is \eqn{10^{-4}}.}

\item{sig2.true}{The default is false, \eqn{\sigma^2} will be estimated; if sig2 is known and its value is given, then \eqn{\sigma^2} will not be estimated.}

\item{threshold}{The threshold to determine whether \eqn{\gamma_j} is 0 or 1; the default value is 0.5.}

\item{theta.int}{The initial value of theta mean; if not provided, the algorithm will estimate it using PCA.}

\item{theta.var.int}{The initial value of theta.var; if not provided, the algorithm will set it to be 1e-3*diag(r).}

\item{kappa.para1}{The value of \eqn{\alpha_1} of \eqn{\pi(\kappa)}; default is 1.}

\item{kappa.para2}{The value of \eqn{\alpha_2} of \eqn{\pi(\kappa)}; default is \eqn{p+1}.}

\item{sigma.a}{The value of \eqn{\sigma_a} of \eqn{\pi(\sigma^2)}; default is 1.}

\item{sigma.b}{The value of \eqn{\sigma_b} of \eqn{\pi(\sigma^2)}; default is 2.}
}
\value{
\item{iter}{The number of iterations to reach convergence.}
\item{selection}{A vector (if \eqn{r = 1} or with the jointly row-sparsity assumption) or a matrix (if otherwise) containing the estimated value for \eqn{\boldsymbol \gamma}.}
\item{theta.mean}{The loadings matrix.}
\item{theta.var}{The covariance of each non-zero rows in the loadings matrix.}
\item{sig2}{Variance of the noise.}
\item{obj.fn}{A vector contains the value of the objective function of each iteration. It can be used to check whether the algorithm converges}
}
\description{
This function employs the PX-CAVI algorithm proposed in Ning (2020).
The \eqn{g} in the slab density of the spike and slab prior is chosen to be the Laplace density, i.e.,
\eqn{N(0, \sigma^2/\lambda_1 I_r)}.
Details of the model and the prior can be found in the Details section in the description of the `VBsparsePCA()` function.
This function is not capable of handling the case when r > 1. In that case, we recommend to use the multivariate distribution instead.
}
\examples{
#In this example, the first 20 rows in the loadings matrix are nonzero, the rank is 1
set.seed(2021)
library(MASS)
library(pracma)
n <- 200
p <- 1000
s <- 20
r <- 1
sig2 <- 0.1
# generate eigenvectors
U.s <- randortho(s, type = c("orthonormal"))
U <- rep(0, p)
U[1:s] <- as.vector(U.s[, 1:r])
s.star <- rep(0, p)
s.star[1:s] <- 1
eigenvalue <- seq(20, 10, length.out = r)
# generate Sigma
theta.true <- U * sqrt(eigenvalue)
Sigma <- tcrossprod(theta.true) + sig2*diag(p)
# generate n*p dataset
X <- t(mvrnorm(n, mu = rep(0, p), Sigma = Sigma))
result <- spca.cavi.Laplace(x = X, r = 1)
loadings <- result$theta.mean
}
