% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joeBiCopula.R
\name{joeBiCopula}
\alias{joeBiCopula}
\alias{surJoeBiCopula}
\alias{r90JoeBiCopula}
\alias{r270JoeBiCopula}
\title{Constructors for Joe copulas}
\usage{
joeBiCopula(param = 2)

surJoeBiCopula(param = 2)

r90JoeBiCopula(param = -2)

r270JoeBiCopula(param = -2)
}
\arguments{
\item{param}{The parameter \code{param} defines the copula through
\code{theta}.}
}
\value{
One of the respective Joe copula classes
(\linkS4class{joeBiCopula}, \linkS4class{surJoeBiCopula},
\linkS4class{r90JoeBiCopula}, \linkS4class{r270JoeBiCopula}).
}
\description{
Constructs an object of the (survival \code{surJoeBiCopula}, 90 degree
rotated \code{r90JoeBiCopula} and 270 degree rotated \code{r270JoeBiCopula})
family for a given parameter. Note that package \code{\link[copula:copula-package]{copula::copula-package()}}
provides a class \linkS4class{joeBiCopula} as well.
}
\examples{

library(copula)

persp(surJoeBiCopula(1.5), dCopula, zlim = c(0, 10))
persp(r90JoeBiCopula(-1.5), dCopula, zlim = c(0, 10))
persp(r270JoeBiCopula(-1.5), dCopula, zlim = c(0, 10))
}
\references{
Joe, H., (1997). Multivariate Models and Dependence Concepts.
Monogra. Stat. Appl. Probab. 73, London: Chapman and Hall.
}
\seealso{
See also \code{\link[=BB1Copula]{BB1Copula()}}, \code{\link[=BB6Copula]{BB6Copula()}},
\code{\link[=BB7Copula]{BB7Copula()}} and \code{\link[=BB8Copula]{BB8Copula()}} for further wrapper
functions to the \link[VineCopula:VineCopula-package]{VineCopula::VineCopula-package}.
}
