% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{legend.m}
\alias{legend.m}
\title{Add Legend to Margin.}
\usage{
legend.m(
  x = c("center", "bottomright", "bottom", "bottomleft", "left", "topleft", "top",
    "topright", "right"),
  y = NULL,
  margin = c("right", "bottomright", "bottom", "bottomleft", "left", "topleft", "top",
    "topright"),
  offset = 0.05,
  ...
)
}
\arguments{
\item{x}{(character, numeric) either one of the character strings "center","bottomright", "bottom", "bottomleft", 
"left", "topleft", "top", "topright", "right" or a numeric values specifying the X-coordinate in user
coordinates}

\item{y}{(numeric) value specifying the Y-coordiante in user coordinates, only used in case 'x' is numeric}

\item{margin}{(character) string specifying in which part of the margin the legend shall be added, choices are
"right", "bottomright", "bottom", "bottomleft", 
"left", "topleft", "top", "topright" with "right" being the default}

\item{offset}{(numeric) value in [0, 0.5] specifying the offset as fraction in regard to width of the right margin}

\item{...}{all parameters applicable in function \code{\link{legend}}}
}
\description{
This function accepts all parameters applicable in and forwards them to function \code{\link{legend}}.
There will be only made some modifications to the X-coordinate ensuring that the legend is plotted in
the right margin of the graphic device. Make sure that you have reserved sufficient space in the right
margin, e.g. 'plot.VFP(....., mar=c(4,5,4,10))'.
}
\examples{
\dontrun{

par( mar=c(10,10,10,10) )
plot(1, type="n", axes=FALSE, xlab="", ylab="")
box()
# add legend to different regions within the 'margin'
legend.m(margin="topleft", 		fill="black",	legend=c("topleft"))
legend.m(margin="top", 			fill="red", 	legend=c("top"))
legend.m(margin="topright", 		fill="blue",	legend=c("topright"))
legend.m(margin="right", 		fill="green",	legend=c("right"))
legend.m(margin="bottomright", 	fill="yellow",	legend=c("bottomright"))
legend.m(margin="bottom", 		fill="orange",	legend=c("bottom"))
legend.m(margin="bottomleft", 	fill="cyan",	legend=c("bottomleft"))
legend.m(margin="left", 			fill="magenta", legend=c("left"))

data(dataEP05A2_3)
dataEP05A2_3$user <- sample(rep(c(1,2), 40))
 
varPlot( y~day+day:run, dataEP05A2_3, mar=c(1,5,1,7), VCnam=list(side=4), 
	        Points=list(pch=list(var="user", pch=c(2, 8))) )
# always check order of factor levels before annotating
order(unique(dataEP05A2_3$user))
legend.m(pch=c(8,2), legend=c("User 1", "User 2"))

# using different colors 
varPlot( y~day+day:run, dataEP05A2_3, mar=c(1,5,1,7), VCnam=list(side=4),
         Points=list(col=list(var="user", col=c("red", "green"))) )
legend.m(fill=c("green", "red"), legend=c("User 1", "User 2"))

# two additional classification variables
dataEP05A2_3$user <- sample(rep(c(1,2), 40))
dataEP05A2_3$cls2 <- sample(rep(c(1,2), 40))

# now combine point-coloring and plotting symbols
# to indicate two additional classification variables
varPlot( y~day+day:run, dataEP05A2_3, mar=c(1,5,1,10),
         VCnam=list(side=4, cex=1.5),
         Points=list(col=list(var="user", col=c("red", "darkgreen")),
                     pch=list(var="cls2", pch=c(21, 22)),
                     bg =list(var="user", bg =c("orange", "green"))) )

# add legend to (right) margin
legend.m(margin="right", pch=c(21, 22, 22, 22), 
         pt.bg=c("white", "white", "orange", "green"),  
         col=c("black", "black", "white", "white"), 
         pt.cex=c(1.75, 1.75, 2, 2),
         legend=c("Cls2=1", "Cls2=2", "User=2", "User=1"), 
         cex=1.5)
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
