% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{residuals.VFP}
\alias{residuals.VFP}
\title{Residuals Method for Objects of Class 'VFP'.}
\usage{
\method{residuals}{VFP}(object, model.no = NULL, type = c("vc", "sd", "cv"), ...)
}
\arguments{
\item{object}{(object) of class 'VFP'}

\item{model.no}{(integer) model number to be use, if not specified the
best fitting model will be used}

\item{type}{(character) one of "vc" (variance), "sd" or "cv"
on which scale residuals shall be determined}

\item{...}{additional arguments}
}
\description{
Residuals Method for Objects of Class 'VFP'.
}
\examples{
\donttest{
library(VCA)
data(CA19_9)
fits.CA19_9 <- anovaVCA(result~site/day, CA19_9, by="sample")
# extract repeatability
mat.CA19_9 <- get_mat(fits.CA19_9, "error")
res.CA19_9 <- fit_vfp(mat.CA19_9, 1:9)
# default is on variance scale
residuals(res.CA19_9)
# residuals on cv scale for model 6
resid(res.CA19_9, model.no=6, type="cv")
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
