% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SomersD.R
\name{SomersD}
\alias{SomersD}
\title{Somers' D and its asymptotic standard errors}
\usage{
SomersD(y, fx)
}
\arguments{
\item{y}{a vector of realized categories.}

\item{fx}{a vector of predicted values of the ranking function f.}
}
\value{
A list of length three is returned, containing the following components:
\item{val}{Somers' D}
\item{ASE}{the asymptotic standard error of Somers' D}
\item{ASE0}{the modified asymptotic error of Somers' D under the null hypothesis.}
}
\description{
Computes Somers' D on a given cartesian product Y x f(X), where Y consists of the components of \code{y} and f(X) consists of the components of \code{fx}. Furthermore, the asymptotic standard error as well as the modified asymptotic standard error to test the null hypothesis that the measure is zero are provided as defined in Goktas and Oznur (2011).
}
\examples{
SomersD(rep(1:5,each=3),c(3,3,3,rep(2:5,each=3)))
}
\references{
Goktas, A., Oznur, I., 2011. A Comparison of the Most Commonly Used Measures of Association for Doubly Ordered Square Contingency Tables via Simulation. Metodoloski zvezki 8 (1), 17-37
}
