% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlockScholesforGeometricAsianCallOption.R
\name{BS_Asian_geom}
\alias{BS_Asian_geom}
\title{Block Scholes for Geometric Asian Call Option}
\usage{
BS_Asian_geom(K = 100, TimeToMat, d, ti, r = 0.05, sigma = 0.1, S0 = 100, ...)
}
\arguments{
\item{K}{Strike price.}

\item{TimeToMat}{Time to maturity.}

\item{d}{Dimension of input z matrix.}

\item{ti}{Vector of control points.}

\item{r}{Riskfree rate}

\item{sigma}{Yearly volatility.}

\item{S0}{Stock price at start.}

\item{...}{ellipsis parameter. different parameters can be passed depending on the problem.}
}
\value{
Expected value of Geometric Average Asian Call Option, vector of control points, interest rate and strike price as a list.
}
\description{
Function to calculate expected value of Geometric Asian Call Option via Block Scholes formula.
}
\examples{
 sim.outer(n=1e3, d=3, q.outer = myq_asian, K=100, ti=(1:3/12), r=0.03, sigma=0.3, S0=100)
}
