% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myq_asian.R
\name{myq_asian}
\alias{myq_asian}
\title{Block Scholes for Geometric Asian Call Option}
\usage{
myq_asian(zm, K = 100, ti = (1:3)/12, r = 0.05, sigma = 0.1, S0 = 100)
}
\arguments{
\item{zm}{Input matrix with n row and d dimension.}

\item{K}{Strike price.}

\item{ti}{Vector of control points.}

\item{r}{Riskfree rate.}

\item{sigma}{Yearly volatility.}

\item{S0}{Stock price at start.}
}
\value{
Returns 4 elements as a list. Asian Call Option Prices, Last Price of Asian Call Option, Expected Value of Asian Call Option, Product of the prices through time
}
\description{
Function to calculate expected value of Geometric Asian Call Option via Block Scholes formula.
}
\examples{
 sim.outer(n=1e3, d=3, q.outer = sim.IS,
q.is = myq_asian, K=100, ti=(1:3/12), r=0.03, sigma=0.3, S0=100)
}
