% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simInnerCV.R
\name{sim.InnerCV}
\alias{sim.InnerCV}
\title{Function to apply Inner Control Variates Algorithm.}
\usage{
sim.InnerCV(zm, q.cv, ...)
}
\arguments{
\item{zm}{A matrix with dimension d and length n.}

\item{q.cv}{q function that sim.InnerCV function gets target vectors to apply variance reduction.}

\item{...}{ellipsis parameter. different parameters can be passed depending on the problem.}
}
\value{
Updates Y value which stored in list 'results' and returns the list 'results' with updated Y value.
}
\description{
Given matrix input with d dimension, this function aims to reduce the variance by applying Inner Control Variates algorithm. It uses input columns and their squares as inner control variates and applies feature selection for these control variates.
}
\examples{
 sim.outer(n=1e3, d=3, q.outer = sim.InnerCV,
q.cv = myq_asian, K=100, ti=(1:3/12), r=0.03, sigma=0.3, S0=100)

sim.outer(n=1e6, d=6, q.outer = sim.AV, q.av = sim.InnerCV,
q.cv = myq_asian, K=105, ti=(1:6/12), r=0.03, sigma=0.3, S0=100)
}
