% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linVarReg.R
\name{linVarReg}
\alias{linVarReg}
\title{Linear mean and variance regression function}
\usage{
linVarReg(
  dat,
  var.ind = c(2),
  mean.ind = c(2),
  para.space = c("all", "positive", "negative"),
  control = list(...),
  ...
)
}
\arguments{
\item{dat}{Dataframe containing outcome and covariate data. Outcome data must be in the first column. Covariates for mean and variance model in next columns.}

\item{var.ind}{Vector containing the column numbers of the data in 'dat' to be fit as covariates in the variance model. FALSE indicates constant variance option.}

\item{mean.ind}{Vector containing the column numbers of the data in 'dat' to be fit as covariates in the mean model. 0 indicates constant mean option. NULL indicates zero mean option.}

\item{para.space}{Parameter space to search for variance parameter estimates. "positive" means only search positive parameter space, "negative" means search only negative parameter space and "all" means search all.}

\item{control}{List of control parameters. See \code{\link{VarReg.control}}.}

\item{...}{arguments to be used to form the default control argument if it is not supplied
directly}
}
\value{
\code{linVarReg} returns a list of output including:
\itemize{
\item\code{converged}: Logical argument indicating if convergence occurred.
\item\code{iterations}: Total iterations performed of the EM algorithm.
 \item\code{reldiff}: the positive convergence tolerance that occured at the final iteration.
 \item\code{loglik}: Numeric variable of the maximised log-likelihood.
 \item\code{boundary}: Logical argument indicating if estimates are on the boundary.
 \item\code{aic.c}: Akaike information criterion corrected for small samples
 \item\code{aic}: Akaike information criterion
 \item\code{bic}: Bayesian information criterion
 \item\code{hqc}: Hannan-Quinn information criterion
 \item\code{mean.ind}: Vector of integer(s) indicating the column number(s) in the dataframe
 \code{data} that were fit in the mean model.
 \item\code{mean}: Vector of the maximum likelihood estimates of the mean parameters.
 \item \code{var.ind}: Vector of integer(s) indicating the column(s) in the dataframe
 \code{data} that were fit in the variance model.
 \item\code{variance}: Vector of the maximum likelihood estimates of the variance parameters.
 \item\code{cens.ind}: Integer indicating the column in the dataframe \code{data} that
 corresponds to the censoring indicator. Always NULL.
 \item\code{data}: Dataframe containing the variables included in the model.
 }
}
\description{
\code{linVarReg} performs multivariate mean and multivariate variance regression. This function is
 designed to be used by the  \code{\link{semiVarReg}} function.
}
