% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_print.R
\name{print.decomposition}
\alias{print.decomposition}
\title{Decomposition Summary Method}
\usage{
\method{print}{decomposition}(x, ...)
}
\arguments{
\item{x}{An object of class "decomposition".}

\item{...}{Additional arguments.}
}
\value{
A "decomposition" class object.
}
\description{
S3 method for summarizing objects of the class "decomposition".
}
\examples{
 data("park_visitation")

park <- "YELL"
nps_ts <- ts(park_visitation[park_visitation$park == park,]$nps, start = 2005, freq = 12)
nps_ts <- log(nps_ts)

pud_ts <- ts(park_visitation[park_visitation$park == park,]$pud, start = 2005, freq = 12)
pud_ts <- log(pud_ts)
nps_ts <- ts(park_visitation[park_visitation$park == park,]$nps, start = 2005, freq = 12)
nps_ts <- log(nps_ts)


decomposition_pud <- auto_decompose(pud_ts)
decomposition_nps <- auto_decompose(nps_ts)
summary(decomposition_pud)
summary(decomposition_nps)
}
