% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensity_checks.R
\name{intens_check}
\alias{intens_check}
\title{Checking intensities of a data set following the W4M 3-tables format}
\usage{
intens_check(
  DM,
  SM,
  VM,
  method,
  chosen.stat,
  class.col,
  test.fold,
  class1,
  fold.frac,
  logarithm,
  graphs.output
)
}
\arguments{
\item{DM}{Data.frame corresponding to the dataMatrix of your 3-tables data set}

\item{SM}{Data.frame corresponding to the sampleMetadata of your 3-tables data set}

\item{VM}{Data.frame corresponding to the variableMetadata of your 3-tables data set}

\item{method}{Character string among "global", "one_class", "each_class"}

\item{chosen.stat}{Character string listing the chosen analysis (comma-separated) from mean, sd, median, quartile, decile and NA}

\item{class.col}{Character string of the name of the sampleMetadata's column with classes (if method = one_class or each_class)}

\item{test.fold}{Character string among "yes" or "no" to indicate whether mean fold changes should be computed (if method = one_class or each_class)}

\item{class1}{Character string corresponding to the name of the chosen class (if method = one_class)}

\item{fold.frac}{Character string; "Top" for class1/other or "Bottom" for other/class1 (if method = one_class)}

\item{logarithm}{Character string among "log2", "log10" or "none", use for mean fold changes (if method = one_class or each_class)}

\item{graphs.output}{Character string for the pdf file's access for ploting the graphics}
}
\value{
a \code{dataframe} corresponding to the original variableMetadata table completed with additional columns
}
\description{
intens_check
This function allows to check the intensities with various statistics, number of missing values and mean fold change.
It needs 3 datasets: the data matrix, the variables' metadata, the samples' metadata.
It generates 3 new datasets corresponding to the 3 inputs filtered.
}
\details{
Three methods proposed:
(i) 'global' to perform tests for each variable without distinction between samples,
(ii) 'one class' to compute test for one class versus all the remaining samples in an 'other' shared class,
(iii) 'each class' in case the class columns contains at least two classes and you want to test each of them individually.
The function produces a table with the requested indices, plus a PDF output with corresponding graphics.
}
\author{
A.Fernandes, M.Petera
}
