% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPI_calc.R
\name{SPI.calc}
\alias{SPI.calc}
\title{Calculate Standardized Precipitation Index, SPI}
\usage{
SPI.calc(prec.zoo, sc = 24, method = "mle")
}
\arguments{
\item{prec.zoo}{A zoo series contain date and rainfall vector/matrix.}

\item{sc}{The accumulation period in months. Commonly 6, 12, 24, 36, and 48 months.}

\item{method}{A character string coding for the fitting method: "mle" for 'maximum likelihood estimation', "mme" for 'moment matching estimation', "qme" for 'quantile matching estimation' and "mge" for 'maximum goodness-of-fit estimation'.}
}
\value{
A matrix of time series.
}
\description{
Calculate Standardized Precipitation Index, SPI
}
\examples{
data(rain.mon)

## compute SPI
SPI <- SPI.calc(window(rain.mon, start = c(1949, 1), end = c(2009, 12)), sc = 12)

## plot
par(mfrow = c(3, 5))
for (i in seq_len(ncol(SPI))) plot(SPI[, i])
}
