% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{LRfit}
\alias{LRfit}
\title{Estimate the while-alive loss (event) rate}
\usage{
LRfit(id, time, status, trt, Dweight = 0, wH = NULL, wD = NULL)
}
\arguments{
\item{id}{A vector of id variable.}

\item{time}{A vector of follow-up times.}

\item{status}{A vector of event type variable; 1 = recurrent event, 2 = death,
and 0 = censoring.}

\item{trt}{A vector of categorical (binary or multiclass)
variable for treatment group.}

\item{Dweight}{A non-negative weight for death relative to the
recurrent event; Default is 0.}

\item{wH}{A function of \eqn{t} and \eqn{m} to weight recurrent event;
\eqn{t}: time; \eqn{m}: existing number of recurrent event; Default is
the constant function of 1.}

\item{wD}{A function of \eqn{t} and \eqn{m} to weight death;
\eqn{t}: time; \eqn{m}: existing number of recurrent event; Default is
the constant function of 0.}
}
\value{
An object of class \code{LRfit}. See \code{\link{LRfit.object}}
for details.
}
\description{
Estimate and make inference on the while-alive loss (or event) rate
across \eqn{J} groups under a user-specified loss function
}
\examples{
# load the HF-ACTION trial data
head(hfaction_cpx12)
# fit the data
dat<-hfaction_cpx12
obj<-LRfit(dat$id,dat$time,dat$status,dat$trt)
# print the event numbers by group
obj
# summarize the inference results for tau=3.5 years
# with joint test with RMST
summary(obj,tau=3.5,joint.test=TRUE)
# plot the estimated survival-completed cumulative loss
# by group, with 95\% confidence intervals
plot(obj,conf=TRUE,xlab="Time (years)",xlim=c(0, 3.5),ylim=c(0,3),
    ylab="Survival-completed cumulative frequency")
}
\seealso{
\code{\link{LRfit.object}},
\code{\link{summary.LRfit}}, \code{\link{plot.LRfit}}.
}
\keyword{LRfit}
