% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woa_kmedoids.R
\name{woa_kmedoids}
\alias{woa_kmedoids}
\title{Whale Optimization Algorithm for K-Medoids Clustering}
\usage{
woa_kmedoids(
  data,
  ClusNum,
  distance_method = c("dtw", "ed"),
  learned_w = NULL,
  Max_iter = 20,
  n = 5
)
}
\arguments{
\item{data}{Data matrix}

\item{ClusNum}{Number of clusters}

\item{distance_method}{Distance calculation method, either "dtw" or "ed"}

\item{learned_w}{Window size for DTW (only used if distance_method is "dtw")}

\item{Max_iter}{Maximum number of iterations (default is 20, it can be adjusted according to the size of the dataset)}

\item{n}{Population size (number of whales, default is 5, itcan be adjusted according to the size of the dataset)}
}
\value{
The `woa_clustering` object containing the clustering result and medoids
}
\description{
This function implements the Whale Optimization Algorithm (WOA) for K-Medoids clustering.
Supported distance measures are Dynamic Time Warping (DTW) and Euclidean Distance (ED).
}
\examples{
# NOTE: This example only shows how to implement woa_kmedoids using sample data.
# Results do not suggest any meanings.
data(Lightning7)
Lightning7_data <- Lightning7[, -1]  # Remove the first column of classification data
  result <- woa_kmedoids(Lightning7_data, ClusNum = 7, distance_method = "dtw", learned_w = 5)
  print(result)
}
\references{
Mirjalili, S., & Lewis, A. (2016). The whale optimization algorithm. Advances in engineering software, 95, 51-67.
}
\author{
Chenan Huang, Narumasa Tsutsumida
}
