% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_simulation.r
\name{simulate_conditionally.simbase_list}
\alias{simulate_conditionally.simbase_list}
\title{Add simulated values to a dataset conditionally, based on a \code{simbase_list} object}
\usage{
\method{simulate_conditionally}{simbase_list}(
  data,
  simbase,
  force_positive = TRUE,
  ...,
  error_when_groups_missing = TRUE
)
}
\arguments{
\item{data}{The dataset where simulated values are added to.}

\item{simbase}{Basic data object for the simulation, as calculated by
\code{\link{simbase_list}}.}

\item{force_positive}{If \code{TRUE}, the resulting values are forced
to be \eqn{\ge 0}.}

\item{...}{further arguments passed to or from other methods.}

\item{error_when_groups_missing}{Whether to raise an error if for a certain
value combination in the grouping variables no dedicated \code{simbase}
exists (see details).}
}
\value{
The modified dataset \code{data} with simulated values.
}
\description{
Add simulated values to a dataset conditionally, based on a \code{simbase_list} object
}
\details{
Simulating values based on a \code{\link{simbase_list}} object
has some special aspects compared to that of other \code{simbase_*} objects,
(see \code{\link[=simulate_conditionally]{simulate_conditionally()}}).

In particular, a \code{\link{simbase_list}} object stores \code{simbase}s
for specific value combinations within the grouping variables.

These grouping variables must also be present in \code{data}.

If there is a value combination in these grouping variables for which no
dedicated \code{simbase} object exists, this will lead to \code{NA} values
in the columns to be simulated and either to an error
(if \code{error_when_groups_missing = TRUE}) or to a warning.

Due to the internal call to \code{\link[tidyr:nest]{tidyr::nest()}} and subsequent call to
\code{\link[tidyr:unnest]{tidyr::unnest()}}, the returned dataset will be ordered according to
the grouping variables in the simbase, with any grouping variable
combinations missing in the simbase coming last.
}
\examples{
# create a simbase_list object for the values of subsets = c('AT', 'DE')
dataset_0 <- simulate_dataset(subsets = c('AT', 'DE'));
simbase <- simbase_covar(dplyr::group_by(dataset_0, country), c('f', 'E', 'E_dyn'));

# simulate on another dataset
dataset <- data.frame(E_dyn = rnorm(n = 100, mean = 12500, sd = 2200), country = 'AT');
dataset_1 <- simulate_conditionally(dataset, simbase);
head(dataset_1);

# warning if for some value of country we don't have an entry in the simbase
dataset$country <- 'CH';
dataset_2 <- simulate_conditionally(dataset, simbase, error_when_groups_missing = FALSE);
head(dataset_2);

}
