% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WB_brewer.R
\name{WB_brewer}
\alias{WB_brewer}
\title{Customize WrensBookshelf palettes}
\usage{
WB_brewer(
  name,
  n,
  type = c("discrete", "continuous"),
  direction = c(1, -1),
  override.order = FALSE
)
}
\arguments{
\item{name}{Name of palette from WrensBookshelf}

\item{n}{Number of colors to select, or size of continuous palette if n > length(palette)}

\item{type}{Type of palette you wish to generate ("continuous" or "discrete")}

\item{direction}{Direction you want the palette to proceed; 1 = direction shown in ShowBookshelf() or ShowBook(), -1 = reversed.}

\item{override.order}{Argument used to override the prescribed order that colors are selected from palettes for discrete palettes where n < length(palette). Default = FALSE.}
}
\value{
A color palette.
}
\description{
Function used to create continuous/discrete palettes using the palettes in WrensBookshelf.
}
\examples{
WB_brewer(name = "BabyWrenAndTheGreatGift", type = "continuous", n = 200)
WB_brewer(name = "JulienIsAMermaid", type = "discrete",
          direction = -1, n = 7, override.order = TRUE)
}
