% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_ypbp.R
\name{survfit.ypbp}
\alias{survfit.ypbp}
\title{survfit method for ypbp models}
\usage{
\method{survfit}{ypbp}(formula, newdata, ...)
}
\arguments{
\item{formula}{an object of the class ypbp}

\item{newdata}{a data frame containing the set of explanatory variables.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list containing the estimated survival probabilities.
}
\description{
Computes the predicted survivor function for a ypbp model.
}
\examples{
\donttest{
# ML approach:
library(YPBP)
mle <- ypbp(Surv(time, status)~arm, data=ipass, approach="mle")
summary(mle)
ekm <- survival::survfit(Surv(time, status)~arm, data=ipass)
newdata <- data.frame(arm=0:1)
St <- survfit(mle, newdata)
plot(ekm, col=1:2)
with(St, lines(time, surv[[1]]))
with(St, lines(time, surv[[2]], col=2))

# Bayesian approach:
bayes <- ypbp(Surv(time, status) ~ arm, data = ipass,
              approach = "bayes", chains = 2, iter = 100)
summary(bayes)
ekm <- survival::survfit(Surv(time, status)~arm, data=ipass)
newdata <- data.frame(arm=0:1)
St <- survfit(bayes, newdata)
plot(ekm, col=1:2)
with(St, lines(time, surv[[1]]))
with(St, lines(time, surv[[2]], col=2))
}

}
