% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{data_video_request}
\alias{data_video_request}
\title{Video Data Requests - YouTube Data API}
\usage{
data_video_request(
  part = NULL,
  chart = NULL,
  hl = NULL,
  id = NULL,
  locale = NULL,
  maxHeight = NULL,
  maxResults = NULL,
  maxWidth = NULL,
  myRating = NULL,
  onBehalfOfContentOwner = NULL,
  pageToken = NULL,
  regionCode = NULL,
  videoCategoryId = NULL,
  token = getOption("YouTube_Token")
)
}
\arguments{
\item{part}{Required. String}

\item{chart}{String.}

\item{hl}{String.}

\item{id}{String.}

\item{locale}{String.}

\item{maxHeight}{Integer.}

\item{maxResults}{Integer.}

\item{maxWidth}{Integer.}

\item{myRating}{String.}

\item{onBehalfOfContentOwner}{String.}

\item{pageToken}{String.}

\item{regionCode}{String.}

\item{videoCategoryId}{String.}

\item{token}{Required.}
}
\value{
data.frame()
}
\description{
This is a function to make API calls to the YouTube Data API for video data.
While it can be called directly, it is primarily inteded to help get metadata about videos
such as title or description. For more in-depth use of the Data API, please refer to
\code{tuber}. For more details on the following arguments, please refer to
\url{https://developers.google.com/youtube/v3/docs/videos/list}
}
\examples{
\dontrun{
data_video_request(part = "contentDetails",
                          id = "dQw4w9WgXcQ")
}
}
