% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_rad_stats.R
\name{daily.rad.stats}
\alias{daily.rad.stats}
\title{Return daily total radiation statistics for a site}
\usage{
daily.rad.stats(site, bgn.date, end.date)
}
\arguments{
\item{site}{Parameter of class character.
The NEON site data should be downloaded for.}

\item{bgn.date}{Optional. The start date of the period to generate statistics for.
If not supplied, the first date of NEON data will be used.}

\item{end.date}{Optional. The end date of the period to generate statistics for.
If not supplied, the last date of NEON data will be used.}
}
\value{
Mean and maximum daylight total solar radiation values by date,
in watts per meter squared.
}
\description{
This function calculates the daily daylight mean and maximum
total solar radiation values for a site over the specified date range.
}
\examples{
\dontrun{
# Return radiaiton stats for CPER over the summer solstice
cper=Z10::daily.rad.stats(site = "CPER")
# More information on the radiation data product used:
Z10::get.dp.meta("DP1.00014.001")$product.abstract
}
}
\seealso{
Currently none
}
\author{
Robert Lee \email{rhlee@colorado.edu}\cr
}
