% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp_search.R
\name{dp.search}
\alias{dp.search}
\title{Return data product IDs based on a search keyword}
\usage{
dp.search(keyword)
}
\arguments{
\item{keyword}{Parameter of class character.
The search phrase used when searching through data product names.}
}
\value{
A data frame of data product names and their associated data product IDs
}
\description{
For a given keyword or search string, a data frame of possible
data products will be returned. The search is performed against the data product names,
not full data product descriptions.
If the R session is interactive, candidate
data product information will also print in the console.
The data product IDs are used in other Z10 functions to return data.
}
\examples{
\dontrun{
names=Z10::dp.search(keyword="fish")
}
}
\seealso{
Currently none
}
\author{
Robert Lee \email{rhlee@colorado.edu}\cr
}
