% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permDT.R
\name{permDT}
\alias{permDT}
\title{Permutations tests}
\usage{
permDT(
  DT,
  ColNameFactor,
  B = 1000,
  nclust = 1,
  ColNameWeight = "weight",
  ColNameRecep = "ID.recep",
  ColNameSource = "ID.source",
  seed = NULL,
  no_const = FALSE,
  num_class = ColNameFactor,
  other_class = NULL,
  multiple_test = FALSE,
  adjust_method = "none",
  alpha = 0.05
)
}
\arguments{
\item{DT}{a data table contains the factors and the response.}

\item{ColNameFactor}{a char vector with the name of the selected factor.}

\item{B}{number of permutations (use at least B=1000 permutations to get a correct accuracy of the p-value.)}

\item{nclust}{number of proc for parallel computation.}

\item{ColNameWeight}{a char with the name of the ZI response.}

\item{ColNameRecep}{colname of the column with the target names}

\item{ColNameSource}{colname of the column with the contributor names}

\item{seed}{vector with the seed for the permutations: size(\code{seed})=\code{B}}

\item{no_const}{FALSE for receiver block constraint for permutations: TRUE no constraint.}

\item{num_class}{a char vector with the name of numeric factor.}

\item{other_class}{a char vector with the name of other classes than numeric (factor or char).}

\item{multiple_test}{useful option only for discrete factors: Set TRUE to calculate multiple tests.}

\item{adjust_method}{p-values adjusted methods (default "none" ). c("holm", "hochberg", "hommel", "bonferroni", "BH", "BY","fdr", "none").}

\item{alpha}{significant level (default 0.05).}
}
\value{
A data frame with two columns. One for the statistics and the other one for the p-value.
}
\description{
Permutations tests to identify factor correlated
to a zero-inflated proportions response. The statistic are the Spearman's
correlation for numeric factor and mean by level for other factor.
}
\examples{
library(data.table)
data(example_data)
res = permDT (example_data,
colnames(example_data)[c(4,10,14,20)],
B = 10,
nclust = 1,
ColNameWeight = "y",
ColNameRecep = "ID.recep",
ColNameSource = "ID.source",
seed = NULL,
num_class = colnames(example_data)[c(4,10)],
other_class = colnames(example_data)[c(14,20)])
print(res)
}
