% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetDeepComps.R
\name{GetDeepComps}
\alias{GetDeepComps}
\title{Make request to Zillow API GetDeepComps Web Service}
\usage{
GetDeepComps(
  zpid = NULL,
  count = NULL,
  rentzestimate = FALSE,
  zws_id = getOption("ZillowR-zws_id"),
  url = "http://www.zillow.com/webservice/GetDeepComps.htm"
)
}
\arguments{
\item{zpid}{The Zillow Property ID for the property for which to obtain
information. Required.}

\item{count}{The number of comparable recent sales to obtain (between 1 and
25)}

\item{rentzestimate}{Return Rent Zestimate information if available (logical,
default: false).}

\item{zws_id}{The Zillow Web Service Identifier. Required.}

\item{url}{URL for the GetDeepComps Web Service. Required.}
}
\value{
A named list with the following elements:
\describe{
\item{\strong{request}}{a list with the request parameters}
\item{\strong{message}}{a list of status code(s) and message(s)
returned by the API}
\item{\strong{response}}{an XMLNode with the API-specific response
values. At this time, no further coercion is performed, so you
may have to use functions from the \code{XML} package to extract
the desired output.}
}
}
\description{
The GetDeepComps API returns a list of comparable recent sales for a
specified property. The result set returned contains the address, Zillow
property identifier, and Zestimate for the comparable properties and the
principal property for which the comparables are being retrieved. This API
call also returns rich property data for the comparables.
}
\examples{
\dontrun{
GetDeepComps(zpid = 48749425, count = 5)
GetDeepComps(zpid = 48749425, count = 5, rentzestimate = TRUE)}
}
