% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aIs.R
\name{aIc.singular}
\alias{aIc.singular}
\title{\code{aIc.singular} tests for singular data. 
  This is expected to be true if the transform is behaving rationally in
  compositional datasets and also true in the case of datasets with more 
  features than samples.}
\usage{
aIc.singular(
  data,
  norm.method = "prop",
  zero.remove = 0.95,
  zero.method = "prior",
  log = FALSE,
  group = NULL
)
}
\arguments{
\item{data}{can be any dataframe or matrix with samples by column}

\item{norm.method}{can be prop, clr, RLE, TMM, TMMwsp}

\item{zero.remove}{is a value. Filter data to remove features that are 0 
across at least that proportion of samples: default 0.95}

\item{zero.method}{can be any of NULL, prior, GBM or CZM. NULL will not 
impute or change 0 values, GBM (preferred) and CZM are from the 
zCompositions R package, and prior will simply add 0.5 to all counts.}

\item{log}{is a logical. log transform the RLE or TMM outputs, default=FALSE}

\item{group}{is a vector containing group information. Required for clr, RLE, 
TMM, lvha, and iqlr based normalizations.}
}
\value{
Returns a list with a yes/no binary decision in 
  \code{is.singular} and the covariance matrix in \code{cov.matrix}
}
\description{
\code{aIc.singular} tests for singular data. 
  This is expected to be true if the transform is behaving rationally in
  compositional datasets and also true in the case of datasets with more 
  features than samples.
}
\examples{
data(selex)
group = c(rep('N', 7), rep('S', 7))
x <- aIc.singular(selex, group=group, norm.method='clr', zero.method='prior')
}
\author{
Greg Gloor
}
