% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABA_script.R
\name{generate_length_aba}
\alias{generate_length_aba}
\title{Generate Length of Consecutive 'ABA'-Coded Sequences}
\usage{
generate_length_aba(codes_df)
}
\arguments{
\item{codes_df}{A dataframe of codes generated by the generate_codes function
and processed by the create_is_aba function.}
}
\value{
A dataframe of codes with an additional column representing the length of 'ABA' sequences.
}
\description{
This function calculates the length of consecutive 'ABA'-coded sequences
that share common elements in their ID. It assigns NA to non-'ABA' codes.
}
\examples{
speaker_no <- c(3, 2, 3, 1, 4, 2, 4, 1, 4, 3, 2, 3)
sequences <- generate_sequences(speaker_no, 3)
codes <- generate_codes(sequences)
aba <- create_is_aba(codes)
length_aba <- generate_length_aba(aba)

}
