% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abseil.R
\docType{package}
\name{abseil}
\alias{abseil}
\title{abseil}
\description{
Wraps the 'Abseil' 'C++' library for use by R packages. Original files are
  from <https://github.com/abseil/abseil-cpp>. Patches are located at
  <https://github.com/doccstat/abseil-r/tree/main/local/patches>.
}
\examples{
\donttest{
Rcpp::cppFunction(r"{
  #include "absl/strings/str_join.h"
  std::string joinString() {
    std::vector<std::string> v = {"foo","bar","baz"};
    return absl::StrJoin(v, "-");
  }
}", depends = "abseil")

joinString()
}
}
