% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_priors.R
\name{simulate_priors}
\alias{simulate_priors}
\title{Simulate from Parameter Priors}
\usage{
simulate_priors(
  nsamples,
  prior_par = list(mu_psi = 0, sigma_psi = 1, mu_beta = 0, sigma_beta = 1),
  hypothesis = "H1"
)
}
\arguments{
\item{nsamples}{number of samples.}

\item{prior_par}{list with prior parameters. This list needs to contain the
following elements: \code{mu_psi} (prior mean for the normal prior on the
test-relevant log odds ratio), \code{sigma_psi} (prior standard deviation
for the normal prior on the test-relevant log odds ratio), \code{mu_beta}
(prior mean for the normal prior on the grand mean of the log odds),
\code{sigma_beta} (prior standard deviation for the normal prior on the
grand mean of the log odds). Each of the elements needs to be a real number
(the standard deviations need to be positive). The default are standard
normal priors for both the log odds ratio parameter and the grand mean of
the log odds parameter.}

\item{hypothesis}{character specifying whether to sample from a two-sided
prior (i.e., "H1"), a one-sided prior with lower truncation point (i.e.,
"H+"), or a one-sided prior with upper truncation point (i.e., "H-").}
}
\value{
a data frame with prior samples for the following quantities (see
  \code{?ab_test} for a description of the underlying model): \itemize{ \item
  \code{beta}: prior samples for the grand mean of the log odds. \item
  \code{psi}: prior samples for the log odds ratio. \item \code{p1}: prior
  samples for the latent "success" probability in the control group. \item
  \code{p2}: prior samples for the latent "success" probability in the
  experimental group. \item \code{logor}: prior samples for the log odds
  ratio (identical to \code{psi}, only included for easier reference). \item
  \code{or}: prior samples for the odds ratio. \item \code{rrisk}: prior
  samples for the relative risk (i.e., the ratio of the "success" probability
  in the experimental and the control condition). \item \code{arisk}: prior
  samples for the absolute risk (i.e., the difference of the "success"
  probability in the experimental and control condition)}.
}
\description{
Function for simulating from the parameter prior distributions.
}
\examples{
# prior parameters
prior_par <- list(mu_psi = 0, sigma_psi = 1,
                  mu_beta = 0, sigma_beta = 1)

# obtain prior samples
samples <- simulate_priors(nsamples = 1000, prior_par = prior_par)

# plot, e.g., prior samples for absolute risk
hist(samples$arisk)
}
\author{
Quentin F. Gronau
}
