
<!-- README.md is generated from README.Rmd. Please edit that file -->

# abwm

<!-- badges: start -->
<!-- badges: end -->

This package includes one function `abwm.test()`, which performs the
Ansari-Bradley test (Ansari & Bradley, 1960) with missing data proposed
in (Zeng et al., 2025). This method is a theoretical extension of the
Ansari-Bradley test, with controlled Type I error regardless of values
of missing data.

Bounds of the Ansari-Bradley test statistic and its p-value will be
computed in the presence of missing data. The p-value of the test method
proposed in (Zeng et al., 2025) is then returned as the maximum possible
p-value of the Ansari-Bradley test.

## Installation

You can install the development version of abwm from
[GitHub](https://github.com/) with:

``` r
# install.packages("devtools")
devtools::install_github("Yijin-Zeng/Ansari-Bradley-Test-with-Missing-data")
```

## Example

This is a basic example which shows you how to perform the test with
missing data:

``` r
library(abwm)

#### Two-sided test
X <- c(6.2, 3.5, NA, 7.6, 9.2)
Y <- c(NA, 1.3, -0.5, -1.7)
abwm.test(X, Y, alternative = 'two.sided')
#> $p.value
#> [1] 1
#> 
#> $bounds.statistic
#> [1]  7 14
#> 
#> $bounds.pvalue
#> [1] 0.04795881 1.00000000
#> 
#> $alternative
#> [1] "two.sided"
#> 
#> $data.name
#> [1] "X and Y"

## One-sided test
X <- c(6.2, 3.5, NA, 7.6, 9.2)
Y <- c(NA, 1.3, -0.5, -1.7)
abwm.test(X, Y, alternative = 'less')
#> $p.value
#> [1] 0.9176989
#> 
#> $bounds.statistic
#> [1]  7 14
#> 
#> $bounds.pvalue
#> [1] 0.02397941 0.91769888
#> 
#> $alternative
#> [1] "less"
#> 
#> $data.name
#> [1] "X and Y"
```

## See Also

The R function `stats::ansari.test()` performs the Ansari-Bradley test
when data are completely observed.

## References

Y. Zeng, N. M. Adams, D. A. Bodenham. Scale two-sample testing with
arbitrarily missing data. arXiv preprint arXiv:2509.20332. 2025.

A. R. Ansari, R. A. Bradley. Rank-Sum Tests for Dispersions. The Annals
of Mathematical Statistics, pages 1174–1189, 1960.
