% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SZVD_ADMM.R
\name{vec_shrink}
\alias{vec_shrink}
\title{Softmax for SZVD ADMM iterations}
\usage{
vec_shrink(v, a)
}
\arguments{
\item{v}{Vector to be thresholded.}

\item{a}{Vector of tolerances.}
}
\value{
thresholded v vector.

\describe{
  \item{\code{x,y,z}}{Iterates at termination.}
  \item{\code{its}}{Number of iterations required to converge.}
  \item{\code{errtol}}{Stopping error bound at termination}
}
}
\description{
Applies softmax the soft thresholding shrinkage operator to v with tolerance a.
That is, output is the vector with entries with absolute value v_i - a if
|v_i| > a and zero otherwise, with sign pattern matching that of v.
}
\details{
This function is used by other functions and should only be called explicitly for
debugging purposes.
}
\seealso{
Used by: \code{\link{SZVD_ADMM}}.
}
\keyword{internal}
