% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{weartime}
\alias{weartime}
\title{Wear Time Classification}
\usage{
weartime(counts, window = 60L, tol = 0L, tol_upper = 99L, nci = FALSE,
  days_distinct = FALSE, units_day = 1440L)
}
\arguments{
\item{counts}{Integer vector with accelerometer count values.}

\item{window}{Integer value specifying minimum length of a non-wear 
period.}

\item{tol}{Integer value specifying tolerance for non-wear algorithm, i.e. 
number of seconds/minutes with non-zero counts allowed during a non-wear 
interval.}

\item{tol_upper}{Integer value specifying maximum count value for a 
second/minute with non-zero counts during a non-wear interval.}

\item{nci}{Logical value for whether to use algorithm from NCI's SAS 
programs. See \bold{Details}.}

\item{days_distinct}{Logical value for whether to treat each day of data as 
distinct, as opposed to analyzing the entire monitoring period as one 
continuous segment. For minute-to-minute counts, strongly recommend setting 
to \code{FALSE} to correctly classify time near midnight.}

\item{units_day}{Integer value specifying how many data point are in a day. 
Typically either 1440 or 86400 depending on whether count values are 
minute-to-minute or second-to-second.}
}
\value{
Integer vector with 1's for valid wear time and 0's for non-wear 
time.
}
\description{
Classifies wear time vs. non-wear time based on a vector of accelerometer 
count values.
}
\details{
If \code{nci = FALSE}, the algorithm uses a moving window to go through 
every possible interval of length \code{window} in \code{counts}. Any 
interval in which no more than \code{tol} counts are non-zero, and those 
are still < \code{tol.upper}, is classified as non-wear time.

If \code{nci = TRUE}, non-wear time is classified according to the algorithm 
used in the NCI's SAS programs. Briefly, this algorithm defines a non-wear 
period as an interval of length \code{window} that starts with a count value 
of 0, does not contain any periods with \code{(tol + 1)} consecutive 
non-zero count values, and does not contain any counts > \code{tol.upper}. 
If these criteria are met, the non-wear period continues until there are 
\code{(tol + 1)} consecutive non-zero count values or a single count value > 
\code{tol.upper}.
}
\examples{
# Load accelerometer data for first 5 participants in NHANES 2003-2004
data(unidata)

# Get data from ID number 21005
counts.part1 <- unidata[unidata[, "seqn"] == 21005, "paxinten"]

# Identify periods of valid wear time
weartime.flag <- weartime(counts = counts.part1)


}
\references{
National Cancer Institute. Risk factor monitoring and methods: SAS programs 
for analyzing NHANES 2003-2004 accelerometer data. Available at: 
\url{http://riskfactor.cancer.gov/tools/nhanes_pam}. Accessed Aug. 19, 2018.

Acknowledgment: This material is based upon work supported by the National 
Science Foundation Graduate Research Fellowship under Grant No. DGE-0940903.
}
