% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{accept}
\alias{accept}
\title{A flexible version of ACCEPT 2.0 model, which imputes predictors using MICE approach.}
\usage{
accept(
  newdata,
  format = "tibble",
  version = "accept2",
  prediction_interval = FALSE,
  return_predictors = FALSE,
  ...
)
}
\arguments{
\item{newdata}{new patient data with missing values to be imputed before prediction with the same format as accept samplePatients.}

\item{format}{default is "tibble". Can also be set to "json".}

\item{version}{indicates which version of ACCEPT needs to be called. Options include "accept1", "accept2", and "flexccept"}

\item{prediction_interval}{default is FALSE. If set to TRUE, returns prediction intervals of the predictions.}

\item{return_predictors}{default is FALSE. IF set to TRUE, returns the predictors along with prediction results.}

\item{...}{for other versions of accept.}
}
\value{
patientData with prediction.
}
\description{
A flexible version of ACCEPT 2.0 model, which imputes predictors using MICE approach.
}
\examples{
results <- accept(newdata = samplePatients)
}
